#ifndef _MATRIX_RATIO_H
#define _MATRIX_RATIO_H

#include <iostream.h>
#include "element.h"
#include "classes.h"

class Ratio:public Element
{
	private:

		int nominator;
		int dominator;

	public:

		Ratio(Ratio &);
		Ratio(int, int);
		~Ratio();

		virtual Element& operator+(Element &element);
		virtual Element& operator-(Element &element);
		virtual Element& operator-();
		virtual Element& operator*(Element &element);

		void optimize();
		virtual float getNum();
		virtual Element& copy();
		virtual int getClass() { return classRatio; };

		virtual ostream & tostream(ostream &stream);

		int getNominator() { return nominator; };
		int getDominator() { return dominator; };

	private:

		int gcd(int a1, int a2);
};

#endif /* #ifndef _MATRIX_RATIO_H */

