#include "ratio.h"
#include "real.h"
#include "complex.h"
#include "matrix.h"

Ratio::Ratio(Ratio &ratio)
{
	nominator = ratio.nominator;
	dominator = ratio.dominator;
}

Ratio::Ratio(int a_nominator, int a_dominator)
{
	nominator = a_nominator;
	dominator = a_dominator;
}

Ratio::~Ratio()
{
}

Element& Ratio::copy()
{
	Ratio *ret = new Ratio(*this);
	return *ret;
}

Element& Ratio::operator+(Element &element)
{
	switch (element.getClass()) {
		case classRatio:
			Ratio *out=new Ratio(
					((Ratio *)(&element))->getNominator() * dominator
					+ ((Ratio *)(&element))->getDominator() * nominator,
					((Ratio*)(&element))->getDominator() * dominator);
			out->optimize();
			return *out;

		case classComplex:
			return element + *this;
	}

	return *(new Real(getNum() + element.getNum()));
}

Element& Ratio::operator-(Element &element)
{
	switch (element.getClass()) {
		case classRatio:
			Ratio *out_ratio = new Ratio(
					((Ratio *)(&element))->getDominator() * nominator
					- ((Ratio *)(&element))->getNominator() * dominator,
					((Ratio *)(&element))->getDominator() * dominator);
			out_ratio->optimize();
			return *out_ratio;

		case classComplex:
			Complex *out_complex = new Complex(
					getNum() - ((Complex*)(&element))->getReal(),
					((Complex*)(&element))->getImaginary());
			return *out_complex;
	}

	return *(new Real(getNum() - element.getNum()));
}

Element& Ratio::operator-()
{
	Ratio *out = new Ratio(-nominator,dominator);
	return *out;
}

Element& Ratio::operator*(Element &element)
{
	switch (element.getClass()) {
		case classRatio:
			Ratio *out=new Ratio(
					((Ratio *)(&element))->getNominator() * nominator,
					((Ratio *)(&element))->getDominator() * dominator);
			out->optimize();
			return *out;

		case classComplex:
			return element * *this;

		case classMatrix:
			return ((Matrix *)(&element))->scalarMultiply(*this);
	}

	return *(new Real(getNum() * element.getNum()));
}

int Ratio::gcd(int a1, int a2)
{
	return a2 == 0 ? a1 : gcd(a2, a1 % a2);
}

void Ratio::optimize()
{
	register int n = gcd(nominator, dominator);
	nominator /= n;
	dominator /= n;
}

float Ratio::getNum()
{
	return (float) nominator / (float) dominator;
}

ostream & Ratio::tostream(ostream &stream)
{
	return stream << nominator << "/" << dominator;
}

