#include "complex.h"
#include "matrix.h"
#include "classes.h"

Complex::Complex(Complex &a_complex)
{
	real      = a_complex.real;
	imaginary = a_complex.imaginary;
}

Complex::Complex(float a_real,float a_imaginary)
{
	real      = a_real;
	imaginary = a_imaginary;
}

Complex::~Complex()
{
}

Element& Complex::copy()
{
	Complex *a = new Complex(real, imaginary);
	return *a;
}

Element& Complex::operator+(Element &element)
{
	if (element.getClass() == classComplex) {
		Complex *ret = new Complex(
				real      + ((Complex *)(&element))->getReal(),
				imaginary + ((Complex *)(&element))->getImaginary());
		return *ret;
	}

	return *(new Complex(real + element.getNum(), imaginary));
}

Element& Complex::operator-(Element &element)
{
	if (element.getClass() == classComplex) {
		Complex *ret = new Complex(
				real      - ((Complex *)(&element))->getReal(),
				imaginary - ((Complex *)(&element))->getImaginary());
		return *ret;
	}

	return *(new Complex(real - element.getNum(), imaginary));
}

Element& Complex::operator-()
{
	Complex *ret = new Complex(-real, -imaginary);
	return *ret;
}

Element& Complex::operator*(Element &element)
{
	switch (element.getClass()) {
		case classComplex:
			Complex *ret = new Complex(
					real * ((Complex *)(&element))->getReal()
					- imaginary * ((Complex *)(&element))->getImaginary(),
					((Complex *)(&element))->getImaginary()
					+ imaginary * ((Complex *)(&element))->getReal());
			return *ret;

		case classMatrix:
			return ((Matrix *)(&element))->scalarMultiply(*this);
	}

	return *(new Complex(real * element.getNum(), imaginary * element.getNum()));
}

ostream & Complex::toStream(ostream &stream)
{
	return stream << real << "+" << imaginary << "i";
}

