#include "real.h"
#include "complex.h"
#include "matrix.h"
#include "classes.h"

Real::Real(Real &a_real)
{
	number = a_real.number;
}

Real::Real(float a_float)
{
	number = a_float;
}

Real::~Real()
{
	number = 0;
}

Element& Real::copy()
{
	Real *a = new Real(number);
	return *a;
}

Element& Real::operator+(Element &element)
{
	if (element.getClass() == classComplex)
		return element + (*this);

	return *(new Real(number + element.getNum()));
}

Element& Real::operator-(Element &element)
{
	if (element.getClass() == classComplex) {
		Complex *out = new Complex(
				number - ((Complex *)(&element))->getReal(),
				((Complex *)(&element))->getImaginary());
		return *out;
	}

	return *(new Real(number-element.getNum()));
}

Element& Real::operator-()
{
	Real *out = new Real(-number);
	return *out;
}

Element& Real::operator*(Element &element)
{
	switch (element.getClass()) {
		case classComplex:
			return element * *this;

		case classMatrix:
			return ((Matrix *)(&element))->scalarMultiply(*this);
	}

	return *(new Real(number * element.getNum()));
}

float Real::getNum()
{
	return number;
}

ostream & Real::toStream(ostream &stream)
{
	return stream << number;
}

