#include "number.h"
#include "real.h"
#include "classes.h"

Number::Number(Element &a_element)
{
	element = &a_element.copy();
}

Number::Number(float a_float)
{
	element = new Real(a_float);
}

Number::Number(Number &number)
{
	element = &number.copyElement();
}

Number::~Number()
{
	if (element != NULL)
		delete element;
}

Number& Number::copy()
{
	Number *ret = new Number(*element);
	return *ret;
}

Number& Number::operator+(Number &a_element)
{
	Number *ret = new Number(*element + *a_element.element);
	return *ret;
}

Number& Number::operator-(Number &a_element)
{
	Number *ret = new Number(*element - *a_element.element);
	return *ret;
}

Number& Number::operator-()
{
	return *this;
}

Number& Number::operator*(Number &a_element)
{
	Number *ret = new Number(*element * *a_element.element);
	return *ret;
}

Number& Number::operator=(Number &a_element)
{
	if (element != NULL)
		delete element;

	element = &a_element.copyElement();
	return *this;
}


Number& Number::operator+(Element &a_element)
{
	*this = *element + a_element;
	return *this;
}

Number& Number::operator-(Element &a_element)
{
	*this = *element - a_element;
	return *this;
}

Number& Number::operator*(Element &a_element)
{
	*this = *element * a_element;
	return *this;
}

Number& Number::operator=(Element &a_element)
{
	if (element != NULL)
		delete element;

	element = &a_element.copy();
	return *this;
}

Number& Number::operator=(double a_double)
{
	*this = Real((float) a_double);
	return *this;
}

float Number::getNum()
{
	return element == NULL ? 0 : element->getNum();
}

int Number::getClass()
{
	return element == NULL ? classNone : element->getClass();
}

ostream & operator <<(ostream &stream, Number &number)
{
	return number.element == NULL ? stream : number.element->toStream(stream);
}

Element& Number::copyElement()
{
	return element == NULL ? *(Element *)(new Real(0)) : element->copy();
}

